#ifndef _SIGNIN_SONY_H
#define _SIGNIN_SONY_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	PRX_EXPORT ErrorCode PrxSignin();
	PRX_EXPORT bool PrxSigninIsBusy();
	PRX_EXPORT bool PrxIsSignedIn();
	PRX_EXPORT bool PrxSigninGetLastError(ResultCode* result);

	class SignedInState
	{
	private:
		SimpleLock m_Lock;
		bool m_Busy;
		bool m_DialogOpen;
		bool m_PlatformSignedIn;
		bool m_ApplicationSignedIn;
		ResultCode m_LastResult;

	public:
		SignedInState();
		virtual ~SignedInState() {};

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }
		bool IsSignedIn() const { return m_ApplicationSignedIn; }
		bool IsDialogOpen() const { return m_DialogOpen; }
		ErrorCode SignIn();
		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

	private:
		void SignInSuccessful(void);
	};

	extern SignedInState gSignedInState;
	extern int gCurrentPS4UserId;



}

#endif // _SIGNIN_SONY_H
